import { world } from "@minecraft/server";

world.afterEvents.playerPlaceBlock.subscribe((event) => {
    const player = event.player; 
    const block = event.block;
    const blockPos = block.location;

    if (block.typeId === "zc:aetb") {
        
        player.runCommand(`summon zc:advance_enchantment_book ${blockPos.x} ${blockPos.y + 1} ${blockPos.z}`);
    }
});

world.afterEvents.playerBreakBlock.subscribe((event) => {
    const player = event.player;
    const block = event.block;   
    const blockPos = block.location; 

    if (block.typeId === "zc:aetb") {
        player.runCommand(`kill @e[type=zc:advance_enchantment_book]`);
    }
});